package model;

/**
 * This implementation of {@link MathOperation} computes the sum of two float
 * values
 * 
 * @author simone
 * @since 1.0
 * @version 1.0
 *
 */
public class Adder implements MathOperation {

	private float firstAddend;
	private float secondAddend;

	/**
	 * Create a new istance of Adder, by giving it the two addends to be used
	 * 
	 * @param a
	 *            : first addend
	 * @param b
	 *            : second addend
	 */
	public Adder(float a, float b) {
		this.firstAddend = a;
		this.secondAddend = b;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see model.MathOperation#compute()
	 */
	@Override
	public float compute() {
		return this.firstAddend + this.secondAddend;
	}

}
